/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1684;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5275;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.Bound;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.LuminizerBlock;
import vazkii.botania.common.block.block_entity.AnimatedTorchBlockEntity;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class LuminizerBlockEntity
extends BotaniaBlockEntity
implements WandBindable {
    public static final int MAX_DIST = 20;
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    private static final String TAG_NO_PARTICLE = "noParticle";
    private class_2338 bindPos = Bound.UNBOUND_POS;
    private int ticksElapsed = 0;
    private boolean noParticle = false;

    public LuminizerBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaBlockEntities.LIGHT_RELAY, pos, state);
    }

    public void mountEntity(class_1297 e) {
        class_2338 nextDest = this.getNextDestination();
        if (e.method_5765() || this.field_11863.field_9236 || nextDest == null || !this.isValidBinding()) {
            return;
        }
        PlayerMoverEntity mover = new PlayerMoverEntity(this.field_11863, this.field_11867, nextDest);
        this.field_11863.method_8649((class_1297)mover);
        e.method_5804((class_1297)mover);
        if (!(e instanceof class_1542)) {
            mover.method_5783(BotaniaSounds.lightRelay, 1.0f, (float)Math.random() * 0.3f + 0.7f);
        }
        if (e instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)e;
            PlayerHelper.grantCriterion(serverPlayer, ResourceLocationHelper.prefix("main/luminizer_ride"), "code_triggered");
        }
    }

    public static void clientTick(class_1937 level, class_2338 worldPosition, class_2680 state, LuminizerBlockEntity self) {
        class_243 vec;
        ++self.ticksElapsed;
        class_2338 nextDest = self.getNextDestination();
        if (!self.isNoParticle() && nextDest != null && nextDest.method_10264() != Integer.MIN_VALUE && self.isValidBinding() && (vec = self.getMovementVector()) != null) {
            double dist = 0.1;
            int size = (int)(vec.method_1033() / dist);
            int count = 10;
            int start = self.ticksElapsed % size;
            class_243 vecMag = vec.method_1029().method_1021(dist);
            class_243 vecTip = vecMag.method_1021((double)start).method_1031((double)worldPosition.method_10263() + 0.5, (double)worldPosition.method_10264() + 0.5, (double)worldPosition.method_10260() + 0.5);
            double radPer = 0.19634954084936207;
            float mul = 0.5f;
            float mulPer = 0.4f;
            float maxMul = 2.0f;
            WispParticleData data = WispParticleData.wisp(0.1f, 0.4f, 0.4f, 1.0f, 1.0f);
            for (int i = start; i < start + count; ++i) {
                mul = Math.min(maxMul, mul + mulPer);
                double rad = radPer * ((double)i + (double)self.ticksElapsed * 0.4);
                class_243 intermediate = vecMag.method_1036(VecHelper.ONE).method_1021((double)mul);
                class_243 vecRot = VecHelper.rotate(intermediate, rad, vecMag).method_1019(vecTip);
                level.method_8406((class_2394)data, vecRot.field_1352, vecRot.field_1351, vecRot.field_1350, (double)((float)(-vecMag.field_1352)), (double)((float)(-vecMag.field_1351)), (double)((float)(-vecMag.field_1350)));
                vecTip = vecTip.method_1019(vecMag);
            }
        }
    }

    public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, LuminizerBlockEntity self) {
        class_2338 endpoint;
        ++self.ticksElapsed;
        class_2338 nextDest = self.getNextDestination();
        if (nextDest != null && nextDest.method_10264() != Integer.MIN_VALUE && self.isValidBinding() && (endpoint = self.getEndpoint()) != null) {
            class_238 aabb = state.method_26218((class_1922)level, worldPosition).method_1107().method_996(worldPosition);
            float range = 0.6f;
            List enderPearls = level.method_18467(class_1684.class, aabb.method_1014((double)range));
            for (class_1684 pearl : enderPearls) {
                pearl.method_5859((double)endpoint.method_10263() + pearl.method_23317() - (double)worldPosition.method_10263(), (double)endpoint.method_10264() + pearl.method_23318() - (double)worldPosition.method_10264(), (double)endpoint.method_10260() + pearl.method_23321() - (double)worldPosition.method_10260());
            }
        }
    }

    private boolean isValidBinding() {
        class_2338 nextDest = this.getNextDestination();
        if (nextDest == null) {
            return false;
        }
        class_2248 block = this.field_11863.method_8320(nextDest).method_26204();
        return block instanceof LuminizerBlock;
    }

    private class_2338 getEndpoint() {
        ArrayList<LuminizerBlockEntity> pointsPassed = new ArrayList<LuminizerBlockEntity>();
        LuminizerBlockEntity relay = this;
        class_2338 lastCoords = null;
        boolean run = true;
        while (run) {
            LuminizerBlockEntity tileRelay;
            if (pointsPassed.contains(relay)) {
                return null;
            }
            pointsPassed.add(relay);
            class_2338 coords = relay.getNextDestination();
            if (coords == null) {
                return lastCoords;
            }
            class_2586 tile = this.field_11863.method_8321(coords);
            if (tile == null || !(tile instanceof LuminizerBlockEntity)) {
                return lastCoords;
            }
            relay = tileRelay = (LuminizerBlockEntity)tile;
            lastCoords = coords;
        }
        return null;
    }

    public void setNoParticle() {
        this.noParticle = true;
    }

    public boolean isNoParticle() {
        return this.noParticle;
    }

    public class_243 getMovementVector() {
        class_2338 dest = this.getNextDestination();
        if (dest == null) {
            return null;
        }
        return new class_243((double)(dest.method_10263() - this.field_11867.method_10263()), (double)(dest.method_10264() - this.field_11867.method_10264()), (double)(dest.method_10260() - this.field_11867.method_10260()));
    }

    @Override
    public class_2338 getBinding() {
        return this.bindPos;
    }

    public class_2338 getNextDestination() {
        class_2680 state = this.method_11010();
        if (state.method_27852(BotaniaBlocks.lightRelayToggle) && ((Boolean)state.method_11654((class_2769)class_2741.field_12484)).booleanValue()) {
            return null;
        }
        if (state.method_27852(BotaniaBlocks.lightRelayFork)) {
            class_2338 torchPos = null;
            for (int i = -2; i < 3; ++i) {
                class_2338 testPos = this.field_11867.method_10069(0, i, 0);
                class_2680 testState = this.field_11863.method_8320(testPos);
                if (!testState.method_27852(BotaniaBlocks.animatedTorch)) continue;
                torchPos = testPos;
                break;
            }
            if (torchPos != null) {
                AnimatedTorchBlockEntity torch = (AnimatedTorchBlockEntity)this.field_11863.method_8321(torchPos);
                class_2350 side = AnimatedTorchBlockEntity.SIDES[torch.side].method_10153();
                for (int i = 1; i < 20; ++i) {
                    class_2338 testPos = this.field_11867.method_10079(side, i);
                    class_2680 testState = this.field_11863.method_8320(testPos);
                    if (!(testState.method_26204() instanceof LuminizerBlock)) continue;
                    return testPos;
                }
            }
        }
        return this.getBinding();
    }

    @Override
    public boolean canSelect(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
        return true;
    }

    @Override
    public boolean bindTo(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
        if (!(player.method_37908().method_8320(pos).method_26204() instanceof LuminizerBlock) || pos.method_10262((class_2382)this.method_11016()) > 400.0) {
            return false;
        }
        this.bindPos = pos;
        this.method_5431();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        return true;
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        this.bindPos = new class_2338(cmp.method_10550(TAG_BIND_X), cmp.method_10550(TAG_BIND_Y), cmp.method_10550(TAG_BIND_Z));
        this.noParticle = cmp.method_10577(TAG_NO_PARTICLE);
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        cmp.method_10569(TAG_BIND_X, this.bindPos.method_10263());
        cmp.method_10569(TAG_BIND_Y, this.bindPos.method_10264());
        cmp.method_10569(TAG_BIND_Z, this.bindPos.method_10260());
        cmp.method_10556(TAG_NO_PARTICLE, this.noParticle);
    }

    public static class PlayerMoverEntity
    extends class_1297 {
        private static final String TAG_EXIT_X = "exitX";
        private static final String TAG_EXIT_Y = "exitY";
        private static final String TAG_EXIT_Z = "exitZ";
        private static final class_2940<class_2338> EXIT_POS = class_2945.method_12791(PlayerMoverEntity.class, (class_2941)class_2943.field_13324);

        public PlayerMoverEntity(class_1299<PlayerMoverEntity> type, class_1937 world) {
            super(type, world);
            this.field_5960 = true;
        }

        public PlayerMoverEntity(class_1937 world, class_2338 pos, class_2338 exitPos) {
            this(BotaniaEntities.PLAYER_MOVER, world);
            this.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            this.setExit(exitPos);
        }

        protected void method_5693() {
            this.field_6011.method_12784(EXIT_POS, (Object)ManaBurst.NO_SOURCE);
        }

        public void method_5773() {
            super.method_5773();
            if (this.method_5685().isEmpty() && !this.method_37908().field_9236) {
                this.method_31472();
                return;
            }
            boolean isItem = this.method_5685().stream().allMatch(class_1542.class::isInstance);
            if (!isItem && this.field_6012 % 30 == 0) {
                this.method_5783(BotaniaSounds.lightRelay, 0.25f, (float)Math.random() * 0.3f + 0.7f);
            }
            if (!isItem && this.field_6012 % 10 == 0) {
                this.method_32876(class_5712.field_28158);
            }
            class_2338 pos = this.method_24515();
            class_2338 exitPos = this.getExitPos();
            if (!this.method_37908().field_9236 && pos.equals((Object)exitPos)) {
                boolean done = true;
                class_2586 tile = this.method_37908().method_8321(pos);
                if (tile instanceof LuminizerBlockEntity) {
                    class_2338 bind;
                    LuminizerBlockEntity relay = (LuminizerBlockEntity)tile;
                    class_2680 state = this.method_37908().method_8320(pos);
                    if (state.method_27852(BotaniaBlocks.lightRelayDetector)) {
                        this.method_37908().method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(true)));
                        this.method_37908().method_39279(pos, state.method_26204(), 2);
                    }
                    if ((bind = relay.getNextDestination()) != null && relay.isValidBinding()) {
                        this.setExit(bind);
                        done = false;
                    }
                }
                if (done) {
                    for (class_1297 e : this.method_5685()) {
                        e.method_5848();
                    }
                    this.method_31472();
                    return;
                }
            }
            class_243 thisVec = this.method_19538();
            class_243 motVec = thisVec.method_22882().method_1031((double)exitPos.method_10263() + 0.5, (double)exitPos.method_10264() + 0.5, (double)exitPos.method_10260() + 0.5).method_1029().method_1021(0.5);
            int count = 4;
            for (int i = 0; i < count; ++i) {
                int color = class_3532.method_15369((float)((float)this.field_6012 / 36.0f + 1.0f / (float)count * (float)i), (float)1.0f, (float)1.0f);
                double rad = Math.PI * 2 / (double)count * (double)i + (double)this.field_6012 / Math.PI;
                double cos = Math.cos(rad);
                double sin = Math.sin(rad);
                double s = 0.4;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                SparkleParticleData data = SparkleParticleData.sparkle(1.2f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 10);
                this.method_37908().method_8406((class_2394)data, this.method_23317() + cos * s, this.method_23318() - 0.5, this.method_23321() + sin * s, 0.0, 0.0, 0.0);
            }
            this.method_5814(this.method_23317() + motVec.field_1352, this.method_23318() + motVec.field_1351, this.method_23321() + motVec.field_1350);
        }

        public boolean shouldRiderSit() {
            return false;
        }

        public boolean method_5643(@NotNull class_1282 source, float damage) {
            return false;
        }

        protected void method_5749(@NotNull class_2487 cmp) {
            this.setExit(new class_2338(cmp.method_10550(TAG_EXIT_X), cmp.method_10550(TAG_EXIT_Y), cmp.method_10550(TAG_EXIT_Z)));
        }

        protected void method_5652(@NotNull class_2487 cmp) {
            class_2338 exit = this.getExitPos();
            cmp.method_10569(TAG_EXIT_X, exit.method_10263());
            cmp.method_10569(TAG_EXIT_Y, exit.method_10264());
            cmp.method_10569(TAG_EXIT_Z, exit.method_10260());
        }

        public class_243 method_24829(class_1309 living) {
            class_2350 direction = living.method_5735();
            int[][] aint = class_5275.method_27934((class_2350)direction);
            class_2338 blockpos = this.method_24515();
            class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
            for (class_4050 pose : living.method_24831()) {
                class_238 axisalignedbb = living.method_24833(pose);
                for (int[] aint1 : aint) {
                    blockpos$mutable.method_10103(blockpos.method_10263() + aint1[0], blockpos.method_10264(), blockpos.method_10260() + aint1[1]);
                    double d0 = this.method_37908().method_30347((class_2338)blockpos$mutable);
                    if (!class_5275.method_27932((double)d0)) continue;
                    class_243 vector3d = class_243.method_26410((class_2382)blockpos$mutable, (double)d0);
                    if (!class_5275.method_27933((class_1941)this.method_37908(), (class_1309)living, (class_238)axisalignedbb.method_997(vector3d))) continue;
                    living.method_18380(pose);
                    return vector3d;
                }
            }
            return super.method_24829(living);
        }

        public class_2596<class_2602> method_18002() {
            return new class_2604((class_1297)this);
        }

        public class_2338 getExitPos() {
            return (class_2338)this.field_6011.method_12789(EXIT_POS);
        }

        public void setExit(class_2338 pos) {
            this.field_6011.method_12778(EXIT_POS, (Object)pos);
        }
    }
}

