/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.configdata;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_6008;
import net.minecraft.class_6012;
import net.minecraft.class_7061;
import vazkii.botania.api.configdata.LooniumMobAttributeModifier;
import vazkii.botania.api.configdata.LooniumMobEffectToApply;
import vazkii.botania.api.configdata.LooniumMobSpawnData;

public class LooniumStructureConfiguration {
    public static final int DEFAULT_COST = 35000;
    public static final int DEFAULT_MAX_NEARBY_MOBS = 10;
    public static final Codec<LooniumStructureConfiguration> CODEC = class_5699.method_48112((Codec)RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("parent").forGetter(lsc -> Optional.ofNullable(lsc.parent)), (App)class_5699.field_33441.optionalFieldOf("manaCost").forGetter(lsc -> Optional.ofNullable(lsc.manaCost)), (App)class_5699.field_33442.optionalFieldOf("maxNearbyMobs").forGetter(lsc -> Optional.ofNullable(lsc.maxNearbyMobs)), (App)class_7061.class_7062.field_37202.optionalFieldOf("boundingBoxType").forGetter(lsc -> Optional.ofNullable(lsc.boundingBoxType)), (App)class_6012.method_34991(LooniumMobSpawnData.CODEC).optionalFieldOf("spawnedMobs").forGetter(lsc -> Optional.ofNullable(lsc.spawnedMobs)), (App)Codec.list(LooniumMobAttributeModifier.CODEC).optionalFieldOf("attributeModifiers").forGetter(lsc -> Optional.ofNullable(lsc.attributeModifiers)), (App)Codec.list(LooniumMobEffectToApply.CODEC).optionalFieldOf("effectsToApply").forGetter(lsc -> Optional.ofNullable(lsc.effectsToApply))).apply((Applicative)instance, LooniumStructureConfiguration::create)), lsc -> {
        if (lsc.parent == null && (lsc.manaCost == null || lsc.boundingBoxType == null || lsc.spawnedMobs == null)) {
            return DataResult.error(() -> "Mana cost, bounding box type, and spawned mobs must be specified if there is no parent configuration");
        }
        if (lsc.spawnedMobs != null && lsc.spawnedMobs.method_34993()) {
            return DataResult.error(() -> "Spawned mobs cannot be empty");
        }
        if (lsc.manaCost != null && lsc.manaCost > 35000) {
            return DataResult.error(() -> "Mana costs above %d are currently not supported".formatted(35000));
        }
        return DataResult.success((Object)lsc);
    });
    public static final class_2960 DEFAULT_CONFIG_ID = new class_2960("botania", "default");
    public final Integer manaCost;
    public final Integer maxNearbyMobs;
    public final class_7061.class_7062 boundingBoxType;
    public final class_6012<LooniumMobSpawnData> spawnedMobs;
    public final List<LooniumMobAttributeModifier> attributeModifiers;
    public final List<LooniumMobEffectToApply> effectsToApply;
    public final class_2960 parent;

    private LooniumStructureConfiguration(class_2960 parent, Integer manaCost, Integer maxNearbyMobs, class_7061.class_7062 boundingBoxType, class_6012<LooniumMobSpawnData> spawnedMobs, List<LooniumMobAttributeModifier> attributeModifiers, List<LooniumMobEffectToApply> effectsToApply) {
        this.manaCost = manaCost;
        this.maxNearbyMobs = maxNearbyMobs;
        this.spawnedMobs = spawnedMobs;
        this.boundingBoxType = boundingBoxType;
        this.attributeModifiers = attributeModifiers != null ? ImmutableList.copyOf(attributeModifiers) : null;
        this.effectsToApply = effectsToApply != null ? ImmutableList.copyOf(effectsToApply) : null;
        this.parent = parent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder forParent(class_2960 parent) {
        return LooniumStructureConfiguration.builder().parent(parent);
    }

    public LooniumStructureConfiguration getEffectiveConfig(Function<class_2960, LooniumStructureConfiguration> parentSupplier) {
        if (this.parent == null) {
            return this;
        }
        LooniumStructureConfiguration parentConfig = parentSupplier.apply(this.parent).getEffectiveConfig(parentSupplier);
        return new LooniumStructureConfiguration(null, this.manaCost != null ? this.manaCost : parentConfig.manaCost, this.maxNearbyMobs != null ? this.maxNearbyMobs : parentConfig.maxNearbyMobs, this.boundingBoxType != null ? this.boundingBoxType : parentConfig.boundingBoxType, this.spawnedMobs != null ? this.spawnedMobs : parentConfig.spawnedMobs, this.attributeModifiers != null ? this.attributeModifiers : parentConfig.attributeModifiers, this.effectsToApply != null ? this.effectsToApply : parentConfig.effectsToApply);
    }

    public String toString() {
        return "LooniumStructureConfiguration{manaCost=" + this.manaCost + ", maxNearbyMobs=" + this.maxNearbyMobs + ", boundingBoxType=" + String.valueOf(this.boundingBoxType) + ", spawnedMobs=" + String.valueOf(this.spawnedMobs != null ? this.spawnedMobs.method_34994() : null) + ", attributeModifiers=" + String.valueOf(this.attributeModifiers) + ", effectsToApply=" + String.valueOf(this.effectsToApply) + ", parent=" + String.valueOf(this.parent) + "}";
    }

    private static LooniumStructureConfiguration create(Optional<class_2960> parent, Optional<Integer> manaCost, Optional<Integer> maxNearbyMobs, Optional<class_7061.class_7062> boundingBoxType, Optional<class_6012<LooniumMobSpawnData>> spawnedMobs, Optional<List<LooniumMobAttributeModifier>> attributeModifiers, Optional<List<LooniumMobEffectToApply>> effectsToApply) {
        return new LooniumStructureConfiguration(parent.orElse(null), manaCost.orElse(null), maxNearbyMobs.orElse(null), boundingBoxType.orElse(null), (class_6012<LooniumMobSpawnData>)((class_6012)spawnedMobs.orElse(null)), attributeModifiers.orElse(null), effectsToApply.orElse(null));
    }

    public static class Builder {
        private class_2960 parent;
        private Integer manaCost;
        private Integer maxNearbyMobs;
        private class_7061.class_7062 boundingBoxType;
        private class_6012<LooniumMobSpawnData> spawnedMobs;
        private List<LooniumMobAttributeModifier> attributeModifiers;
        private List<LooniumMobEffectToApply> effectsToApply;

        private Builder() {
        }

        private Builder parent(class_2960 parent) {
            this.parent = parent;
            return this;
        }

        public Builder manaCost(Integer manaCost) {
            this.manaCost = manaCost;
            return this;
        }

        public Builder maxNearbyMobs(Integer maxNearbyMobs) {
            this.maxNearbyMobs = maxNearbyMobs;
            return this;
        }

        public Builder boundingBoxType(class_7061.class_7062 boundingBoxType) {
            this.boundingBoxType = boundingBoxType;
            return this;
        }

        public Builder spawnedMobs(LooniumMobSpawnData ... spawnedMobs) {
            this.spawnedMobs = class_6012.method_34989((class_6008[])spawnedMobs);
            return this;
        }

        public Builder attributeModifiers(LooniumMobAttributeModifier ... attributeModifiers) {
            this.attributeModifiers = List.of(attributeModifiers);
            return this;
        }

        public Builder effectsToApply(LooniumMobEffectToApply ... effectsToApply) {
            this.effectsToApply = List.of(effectsToApply);
            return this;
        }

        public LooniumStructureConfiguration build() {
            return new LooniumStructureConfiguration(this.parent, this.manaCost, this.maxNearbyMobs, this.boundingBoxType, this.spawnedMobs, this.attributeModifiers, this.effectsToApply);
        }
    }
}

